/**
 * \file: mspin_logging.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MySpin Logging
 *
 * \component: MSPIN
 *
 * \author: Thilo Bjoern Fickel ICT-ADITG/SW2 tfickel@de.adit-jv.com
 *
 * \copyright: (c) 2003 - 2013 ADIT Corporation
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_LOGGING_H_
#define MSPIN_LOGGING_H_

#ifdef  __cplusplus
extern "C"
{
#endif

#ifdef PROJECTBUILD_NISSAN_LCN2
#include <adit_typedef.h>
#else
#include <adit-system/adit_typedef.h>
#endif

#include <stdbool.h>
#include <unistd.h>

#include "mspin_appl_if_adapter.h"

typedef enum MspinVerbosityLevel
{
    eMspinVerbosityDefault = -1,   //!< eMspinVerbosityDefault
    eMspinVerbosityOff = 0x00,     //!< eMspinVerbosityOff
    eMspinVerbosityFatal = 0x01,   //!< eMspinVerbosityFatal
    eMspinVerbosityError = 0x02,   //!< eMspinVerbosityError
    eMspinVerbosityWarn = 0x03,    //!< eMspinVerbosityWarn
    eMspinVerbosityInfo = 0x04,    //!< eMspinVerbosityInfo
    eMspinVerbosityDebug = 0x05,   //!< eMspinVerbosityDebug
    eMspinVerbosityVerbose = 0x06, //!< eMspinVerbosityVerbose
} tMspinVerbosityLevel;

void mspin_log_registerWithDlt(void);

void mspin_log_unregisterWithDlt(void);

void mspin_log_setVerbosityLevel(S32 logLevel, bool prependTime);

void mspin_log_setDestination(MSPIN_LOGGING_DESTINATION type, bool enable, const char* filename);

U32 mspin_log_getDestination(void);

void mspin_log_setMaxFileSize(U64 maxFileSize);

S32 mspin_log_getVerbosityLevel(void);

void mspin_log_enableDestination(MSPIN_LOGGING_DESTINATION destination);

void mspin_log_disableDestination(MSPIN_LOGGING_DESTINATION destination);

bool mspin_log_getTimestamps(void);

void* mspin_log_getDefaultDLTContext(void);

void* mspin_log_getCoreDLTContext(void);

void mspin_log_printLn(tMspinVerbosityLevel level, const char *message, ...);

void mspin_log_printPrefixedLine(void* dltContext, tMspinVerbosityLevel level, const char *prefix, const char *message, ...);

void mspin_log_print(tMspinVerbosityLevel level, const char *message, ...);

size_t mspin_log_getRSS(void);

#ifdef __cplusplus
}
#endif

#endif /* MSPIN_LOGGING_H_ */
